 $(document).ready(function() {
    $('#contact_form').bootstrapValidator({
        // To use feedback icons, ensure that you use Bootstrap v3.1.0 or later
        feedbackIcons: {
            valid: 'fa fa-ok',
            invalid: 'fa fa-remove',
            validating: 'fa fa-refresh'
        },
        fields: {
            nombre: {
                validators: {
                        stringLength: {
                        min: 2,
                    },
                        notEmpty: {
                        message: 'Porfavor proporciónanos tu nombre'
                    }
                }
            },
             edad: {
                validators: {
					greaterThan: {
                        value: 18,
                        message: 'Debes ser mayor de 18 años'
                    },
                    notEmpty: {
                        message: 'Porfavor proporciónanos tu edad'
                    }
                }
            },
            email: {
                validators: {
                    notEmpty: {
                        message: 'Porfavor proporciónanos tu dirección de e-mail'
                    },
                    emailAddress: {
                        message: 'Porfavor proporciónanos una dirección de e-mail válida'
                    }
                }
            },
            telefono: {
                validators: {
                    notEmpty: {
                        message: 'Porfavor proporciónanos tu teléfono'
                    },
                    phone: {
                        country: 'MX',
                        message: 'Porfavor proporciónanos un teléfono válido'
                    }
                }
            },
            area: {
                validators: {
                     stringLength: {
                        min: 4,
                    },
                    notEmpty: {
                        message: 'Porfavor proporciónanos el área de tu interés'
                    }
                }
                }
            }
        })
        .on('success.form.bv', function(e) {
            $('#success_message').slideDown({ opacity: "show" }, "slow") // Do something ...
                $('#contact_form').data('bootstrapValidator').resetForm();

            // Prevent form submission
            e.preventDefault();

            // Get the form instance
            var $form = $(e.target);

            // Get the BootstrapValidator instance
            var bv = $form.data('bootstrapValidator');

            // Use Ajax to submit form data
            $.post($form.attr('action'), $form.serialize(), function(result) {
                console.log(result);
            }, 'json');
        });
});